<?php

if (
    !isset($_REQUEST['manufacturer_id']) ||
    !isset($_REQUEST['system_id']) ||
    !isset($_REQUEST['type_id'])
) {
    echo "Please go through search page.";
    exit();
}

$host   = "webdev.iyaserver.com"; 
$db     = "dent_exam";
$userid = "dent_test";
$userpw = "Acad276_Ttrojan_Dev2Ex@m";

$mysql = new mysqli(
    $host,
    $userid,
    $userpw,
    $db
);

if($mysql->connect_errno) {
    echo "db connection error : " . $mysql->connect_error;
    exit();
}

$sql = "SELECT d.device_id, d.name, d.price, 
               m.manufacturer AS manufacturer, 
               s.system       AS system, 
               t.type         AS type
        FROM device d
        JOIN make       m ON d.manufacturer_id = m.manufacturer_id
        JOIN os         s ON d.system_id       = s.system_id
        JOIN devicetype t ON d.type_id         = t.type_id
        WHERE 1=1";

$sql .= " AND d.name LIKE '%" . $_REQUEST['device_name'] . "%'";


if($_REQUEST['manufacturer_id'] != "all") {
    $sql .= " AND d.manufacturer_id = " . $_REQUEST['manufacturer_id'];
}
if($_REQUEST['system_id'] != "all") {
    $sql .= " AND d.system_id = " . $_REQUEST['system_id'];
}
if($_REQUEST['type_id'] != "all") {
    $sql .= " AND d.type_id = " . $_REQUEST['type_id'];
}


$sql .= " ORDER BY d.name";

$results = $mysql->query($sql);

if(!$results) {
    echo "<hr>Your SQL:<br> " . $sql . "<br><br>";
    echo "SQL Error: " . $mysql->error . "<hr>";
    exit();
}

?>

<!DOCTYPE html>

<html>

<head lang="en">

    <meta charset="UTF-8">

    <title>Acad276 Practical Exam: Results</title>

    <style>

        .container {

            width:  600px;

            margin: auto;

        }

        h1 {

            margin: auto;

            text-align: center;

            background-color:   #900;

            color:  #FC0;

            height: 60px;

            line-height: 60px;

        }

        .num-results {

            margin: 20px 10px;

        }

        table {

            margin: auto;

            margin-bottom: 20px;

            width:  80%;

            border-collapse: collapse;

        }

        th, td {

            border: 1px solid #900;

            border-collapse: collapse;

            padding:    10px;

            text-align: center;

        }

        img {

            width: 100px;

        }

        .nav-link{

            margin: 10px 0px;

            font-size: 14px;

        }

    </style>

</head>

<body>

<div class="container">

    <h1>Mobile Device Database: Search Results</h1>

    <div class="nav-link">

        <a href="search.php"><< Back to Search Page</a>

    </div>
    
    <div class="num-results">

        Your search returned

        <strong><?php echo $results->num_rows; ?></strong>

        results.

    </div>

<br><br>

<table>
    <tr>

            <th>Name</th>

            <th>Price</th>

            <th>Manufacturer</th>

            <th>System</th>

            <th>Type</th>

        </tr>
    
    <?php while($currentrow = $results->fetch_assoc()) { ?>
        <tr>
            <td><a href="details.php?id=<?php echo $currentrow['device_id']; ?>">
                <?php echo $currentrow['name']; ?>
            </a></td>
            <td><?php echo number_format((float)$currentrow['price'], 2); ?></td>
            <td><?php echo $currentrow['manufacturer']; ?></td>
            <td><?php echo $currentrow['system']; ?></td>
            <td><?php echo $currentrow['type']; ?></td>
        </tr>
    <?php } ?>
    
</table>

</div>

</body>

</html>